                
        AREA    STM32F4xx, CODE, READONLY      ; hlavicka souboru
    
        GET   ini.s                     ; soubor s adresami potrebnch registru
        
konst   EQU     100        	    	    ; direktiva EQU priradi vyrazu 'konst' hodnotu 100
    	    	    	    	    	    
        EXPORT    __main    	    	     ; export navesti pouzivaneho v jinem souboru, zde konkretne
    	EXPORT    __use_two_region_memory    ; jde o navesti, ktere pouziva startup code STM32F10x.s
    	
__use_two_region_memory    
__main    	    	    	    	      	    	    	
    	
    	ENTRY    	    	            ; vstupni bod do kodu, odtud se zacina vykonavat program
        ; HLAVNI PROGRAM
    	
    	BL    	RCC_CNF                 ; Podprogram - nastaven hodin CPU, a sbernic
    	           	           	        ; Skok na adresu s navestim RCC_CNF, ulozeni navratove adresy do LR 
    	BL    	GPIO_CNF            	; Podprogram konfigurace vyvodu LED PA_5

LOOP                                    ; Navesti hlavni smycky    
    	LDR    	R2, =GPIOA_BSRR         ; Adresa brany BSRR do R2     	
    	MOV    	R1, #0x0020             ; Hodnota pro nulovn bitu PA_5
    	STR    	R1, [R2]                ; Zapis hodnoty z R1 na adresu GPIOA BSRR
    	MOV    	R0,#konst               ; Uloen hodnoty zpoden, do DELAY vstupuje v R0
    	BL    	DELAY                   ; Podprogram zpoden 
    	MOV    	R1, #0x0020<<16         ; Vlozeni hodnoty pro rozsvcen PA_5
    	STR    	R1, [R2]                ; Zapis hodnoty do BSRR
    	MOV    	R0,#konst               ; Uloen hodnoty zpoden, do DELAY vstupuje v R0
    	BL    	DELAY                   ; Podprogram zpoden 
    	B    	LOOP                    ; Opakovn smycky

        ; KONFIGURACE HODINOVEHO SIGNALU
        ; Nic: R0,R1,R2
    	
RCC_CNF    
    	LDR    	R0, =RCC_CR             ; Adresa Clock Control Register
CTI
        LDR    	R1, [R0]                ; Cten jeho obsahu do R1
    	AND    	R1, R1, #0x02           ; Vymaskuj bit HSIRDY
    	BEQ     CTI                     ; Cekej na HSIRDY

        ; Nastaven hodinovch signlu = RESET hodnota HSI=CPU=APB1=APB2=16MHz
        LDR     R0, =RCC_AHB1ENR    	       
        MOV     R1, #0x0001             ; Hodnota pro aktivaci brny GPIOA
        LDR    	R2, [R0]    	        ; Nacteni hodnoty z adresy do R2 
        ORR     R2, R2, R1             
        STR     R2, [R0]                ; Aktivace brany A
        BX      LR                      ; Navrat z podprogramu, skok na adresu v LR
 
        ; KONFIGURACE GPIOA PIN5
        ; Nic: R0,R1,R2
        
GPIO_CNF                                
        LDR     R2, =0xFFFFF3FF         ; Konstanta pro nulovani MODER GPIOA PIN5    
    	LDR    	R0, =GPIOA_MODER        ; Adresa GPIOA_MODER
    	LDR    	R1, [R0]    	        ; Nacteni hodnoty z adresy do R1 
    	AND    	R1, R1, R2     	        ; Nulovani bitu v R1 
    	MOV    	R2, #0x400    	        ; Hodnota pro PA_5 Vstup
    	ORR    	R1, R1, R2    	        ; BIT 5 do vstupnho reimu
    	STR    	R1, [R0]    	        ; Ulozeni konfigurace PA_5
    	BX    	LR    	    	        ; Navrat z podprogramu

        ; DELAY
        ; Nici: R0,R3  	
DELAY                                   ; Navesti zacatku podprogramu
    	PUSH    {LR}                    ; Ulozeni navratove adresy - LR do zasobniku 
WAIT1    	    
    	LDR    	R3, =20000    	        ; Vlozeni konstanty pro prodlevu do R2
WAIT    SUBS    R3, R3, #1    	        ; Odecteni 1 od R2,tj. R2 = R2 - 1 a nastaveni priznakoveho registru       
    	BNE    	WAIT                    ; Skok na navesti pri nenulovosti R2 (skok dle priznaku)
    	SUBS    R0, R0, #1
    	BNE    	WAIT1    	    	    	    	    	    	    	  
    	POP    	{LR}                    ; Obnoveni hodnoty LR ze zasobniku
    	BX    	LR                      ; Navrat z podprogramu,
        ALIGN    4                      ; Zarovnn na dlky 32 bitu

        END    	    	    	        ; Konec programu, dal jiz kod prekladac neprelozi
